//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "NTAG5Strings.h"
#import "NTAG5_NFC_LIB.h"
#import "Config.h"
#import "GPIOUseCase.h"
#import "Utils.h"
#import "RFCommands.h"

NS_ASSUME_NONNULL_BEGIN

@interface gpioUseCasePage : UIViewController

/* UI VIEWS */
@property (weak, nonatomic)   IBOutlet          UIView *channel0View;
@property (weak, nonatomic)   IBOutlet          UIView *borderCh1View;
@property (weak, nonatomic)   IBOutlet          UIView *channel1View;
@property (weak, nonatomic)   IBOutlet          UIView *gpioSpeedDropDownList;
@property (weak, nonatomic)   IBOutlet          UIView *slewRateCh1ListView;
@property (weak, nonatomic)   IBOutlet          UIView *slewrateCh1LowSpeedView;
@property (weak, nonatomic)   IBOutlet          UIView *slewrateCh1HighSpeedView;
@property (weak, nonatomic)   IBOutlet          UIView *slewrateCh2DropDown;
@property (weak, nonatomic)   IBOutlet          UIView *slewRateCh2ListView;
@property (weak, nonatomic)   IBOutlet          UIView *slewrateCh2LowSpeedView;
@property (weak, nonatomic)   IBOutlet          UIView *slewrateCh2HighSpeedView;
@property (weak, nonatomic)   IBOutlet          UIView *padConfigDrpDown;
@property (weak, nonatomic)   IBOutlet          UIView *padConfigList;
@property (weak, nonatomic)   IBOutlet          UIView *receiverDisabledOption;
@property (weak, nonatomic)   IBOutlet          UIView *plainInputPullUp;
@property (weak, nonatomic)   IBOutlet          UIView *plainInput;
@property (weak, nonatomic)   IBOutlet          UIView *plainInputPullDown;
@property (weak, nonatomic)   IBOutlet          UIView *configDropDownList;
@property (strong, nonatomic) IBOutlet          UIView *MainView;
@property (weak, nonatomic) IBOutlet UIView *padConfigCh0DropDown;

/* UI LABELS */
@property (weak, nonatomic) IBOutlet            UILabel *channel0Title;
@property (weak, nonatomic) IBOutlet            UILabel *slewRateOptionChosenLabel;
@property (weak, nonatomic) IBOutlet            UILabel *slewRateCh2OptionChosenLabel;
@property (weak, nonatomic) IBOutlet            UILabel *padConfigOptionSelected;
@property (weak, nonatomic) IBOutlet UILabel *padConfigCh0OptionChosenLabel;

/* UI IMAGE VIEWS */
@property (weak, nonatomic) IBOutlet            UIImageView *bulbImageView;
@property (weak, nonatomic) IBOutlet            UIImageView *buttonImageView;

/* UI BUTTONS */
@property (weak, nonatomic) IBOutlet            UIButton *clearGpioOutputButton;
@property (weak, nonatomic) IBOutlet            UIButton *getInputStatusButton;
@property (weak, nonatomic) IBOutlet            UIButton *writeConfigButon;
@property (weak, nonatomic) IBOutlet            UIButton *readConfigButton;

/* UI TEXTVIEWS */
@property (weak, nonatomic) IBOutlet            UITextView *logsTextView;

/* GESTURE & TAP RECOGNIZERS */
- (IBAction)slewRateCh1LosSpeedTap:             (UIGestureRecognizer *)sender;
- (IBAction)slewRateCh1HighSpeedTap:            (UIGestureRecognizer *)sender;
- (IBAction)bulbTap:                            (UIGestureRecognizer *)sender;
- (IBAction)slewRateCh1Tap:                     (UIGestureRecognizer *)sender;
- (IBAction)slewRateCh2Tap:                     (UIGestureRecognizer *)sender;
- (IBAction)padConfigOptionsTap:                (UIGestureRecognizer *)sender;
- (IBAction)receiverDisabledSelected:           (UIGestureRecognizer *)sender;
- (IBAction)weakPullUpSelected:                 (UIGestureRecognizer *)sender;
- (IBAction)plainInputSelected:                 (UIGestureRecognizer *)sender;
- (IBAction)weakPullDownSelected:               (UIGestureRecognizer *)sender;
- (IBAction)setI2cSlaveModeOptionSelected:      (UIGestureRecognizer *)sender;
- (IBAction)setI2cMasterModeOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)setGPIOPWMModeOptionSelected:       (UIGestureRecognizer *)sender;
- (IBAction)getUseCaseCongifOptionSelected:     (UIGestureRecognizer *)sender;

-(IBAction)padConfigCh0OptionsTap:(UIGestureRecognizer *)sender;
-(IBAction)receiverDisabledCh0Selected:(UIGestureRecognizer *)sender;
-(IBAction)weakPullUpCh0Selected:(UIGestureRecognizer *)sender;
-(IBAction)plainInputCh0Selected:(UIGestureRecognizer *)sender;
-(IBAction)weakPullDownCh0Selected:(UIGestureRecognizer *)sender;

- (IBAction)readConfigButtonClick:              (UIButton *)sender;
- (IBAction)clearGPIOOutputButtonClick:         (UIButton *)sender;
- (IBAction)getInputStatusButtonClick:          (UIButton *)sender;
- (IBAction)writeConfigButtonClick:             (UIButton *)sender;

- (IBAction)slewRateCh2LowSpeedOptionSelected:  (id)sender;
- (IBAction)slewRateCh2HighSpeedOptionSelected: (id)sender;
- (IBAction)navBarButtonClick:                  (id)sender;

/* --------------------------------------- */
/*!
 *@abstract   Writes the logs into the GPIO View Controller
 **/
- (void) writeLog:                              (NSString *) cmd
         response:                              (NSData *) resp;

- (void) updateUIWithFirstReadCommand:          (NSData *) response;
- (void) updateUIWithSecondReadCommand:         (NSData *) response;
- (void) updateUIWithGPIOInputCommand:          (NSData *) response;

- (ISO15693Command *) getTagConfigGPIOCommand;
- (ISO15693Command *) getTagSessionGPIOCommand;

@end

NS_ASSUME_NONNULL_END
